class PBMutator expands DMMutator config(PopBalloonsConfig);

#exec AUDIO IMPORT FILE="Sounds\SellSound.wav" NAME="SellSound" GROUP="Towers"

//link to music packages:
#exec OBJ LOAD FILE=..\Music\Botmca9.umx PACKAGE=Botmca9
#exec OBJ LOAD FILE=..\Music\Botpck10.umx PACKAGE=Botpck10
#exec OBJ LOAD FILE=..\Music\Cannon.umx PACKAGE=Cannon
#exec OBJ LOAD FILE=..\Music\Colossus.umx PACKAGE=Colossus
#exec OBJ LOAD FILE=..\Music\Course.umx PACKAGE=Course
#exec OBJ LOAD FILE=..\Music\Credits.umx PACKAGE=Credits NAME=Trophy
#exec OBJ LOAD FILE=..\Music\Ending.umx PACKAGE=Ending
#exec OBJ LOAD FILE=..\Music\Enigma.umx PACKAGE=Enigma
#exec OBJ LOAD FILE=..\Music\firebr.umx PACKAGE=firebr
#exec OBJ LOAD FILE=..\Music\Foregone.umx PACKAGE=Foregone
#exec OBJ LOAD FILE=..\Music\Godown.umx PACKAGE=Godown
#exec OBJ LOAD FILE=..\Music\Lock.umx PACKAGE=Lock
#exec OBJ LOAD FILE=..\Music\Mech8.umx PACKAGE=Mech8
#exec OBJ LOAD FILE=..\Music\Mission.umx PACKAGE=Mission
#exec OBJ LOAD FILE=..\Music\Nether.umx PACKAGE=Nether
#exec OBJ LOAD FILE=..\Music\Organic.umx PACKAGE=Organic
#exec OBJ LOAD FILE=..\Music\Phantom.umx PACKAGE=Phantom
#exec OBJ LOAD FILE=..\Music\Razor-ub.umx PACKAGE=Razor-ub
#exec OBJ LOAD FILE=..\Music\Run.umx PACKAGE=Run
#exec OBJ LOAD FILE=..\Music\SaveMe.umx PACKAGE=SaveMe
#exec OBJ LOAD FILE=..\Music\Savemeg.umx PACKAGE=Savemeg
#exec OBJ LOAD FILE=..\Music\Seeker.umx PACKAGE=Seeker
#exec OBJ LOAD FILE=..\Music\Seeker2.umx PACKAGE=Seeker2
#exec OBJ LOAD FILE=..\Music\Skyward.umx PACKAGE=Skyward
#exec OBJ LOAD FILE=..\Music\Strider.umx PACKAGE=Strider
#exec OBJ LOAD FILE=..\Music\Suprfist.umx PACKAGE=Suprfist
#exec OBJ LOAD FILE=..\Music\UnWorld2.umx PACKAGE=UnWorld2
#exec OBJ LOAD FILE=..\Music\utmenu23.umx PACKAGE=utmenu23
#exec OBJ LOAD FILE=..\Music\Uttitle.umx PACKAGE=Uttitle
#exec OBJ LOAD FILE=..\Music\Wheels.umx PACKAGE=Wheels

var string MapList[512];
var Music MapSong;

var int				NumPlayers;
var config int		MapVoteDelay;
var string			CurrentMapName;

//Configuration for the rounds:
var config String 	Rounds[50];
var config float 	RoundSpawnSpeed[50];
var GRI GRI;

var int 		InitialWait;		//Seconds to delay spawning of first balloon
var int 		CurrentRound;		//Keeps track on the round			
var vector 		SpawnPoint,
				SpawnPointA,
				SpawnPointB,
				SpawnPointC,
				SpawnPointD;		//The location of where to spawn the balloons for each route
var int			Routes;				//How many routes are used in the map
var int			CurrentRoute;		//What route is currently beeing used to spawn baloons from
var int			CurrentlySpawned;	//How many balloons are currently spawned from current route
var int			SpawnFromRoundA,
				SpawnFromRoundB,
				SpawnFromRoundC,
				SpawnFromRoundD;	//Stores the amount of balloons to spawn from each route before switching to next
var bool 		bSpawnFromA;		//True if only one spawnpoint when multiple routes
var bool 		bFirstRun;
var string 	Incomming;		//The string containing the info about what balloons to spawn
var bool 		bLastBalloonSpawned,
				bCanSpawnCamoBalloons,
				bGameOver;
var config int 	StartMoney,
				SpawnCamoFromRound;
var Music 		Songs[200];
var Music 		LevelSong;

var int			TowerNum;

simulated function UpDateDB(String MapName, Bool bBeaten)
{
local Stats A;

	foreach Level.AllActors(Class'Stats',A)
		{
		A.HandleStats(MapName,bBeaten);
		}
}

simulated function LookForCustomWaves()
{
local DefineBalloonWaves A;
local int i, count;

	foreach Level.AllActors(Class'DefineBalloonWaves',A)
		{
		StartMoney = A.StartMoney;
		SpawnCamoFromRound = A.SpawnCamoFromRound;
		count++;
		for (i=0;i<50;i++)
			{
			Rounds[i] = A.Rounds[i];
			RoundSpawnSpeed[i] = A.RoundSpawnSpeed[i];
			if ( A.Rounds[i] == "" )
				log("Pop Balloons !ERROR!: You left round"@i@"empty in your DefineBalloonWaves actor."); 
			}
		}
	if ( count > 1 )
		log ("Pop Balloons !ERROR!: You have placed"@count@"DefineBalloonWaves actors in the map - only 1 is allowed!");
}

simulated function Tick(float DT) 
{
Local Pawn P;
Local PBWeapon PBW;
local GRI GRI;

	foreach Level.AllActors(Class'Pawn',P)
		{
		if ( P.IsA('PlayerPawn') )
			{
			PBW = PBWeapon(P.Weapon);
			if ( PBW != none)
				{
				PBW.AmmoType.AmmoAmount = int(P.PlayerReplicationInfo.Score);
				}
			else
				P.SwitchToBestWeapon();		//Fix so players switches to weapon after placing tower.
			}
		else if ( P.IsA('Bot') )
			P.Destroy();
		}
	Super.Tick(DT);
}

function FindSpawnpoint()
{
local int i;
local NavigationPoint NP;

	Routes = 0;
	bSpawnFromA = False;
	
	//Scan map for path actors:
	for (NP = Level.NavigationPointList; NP != None; NP = NP.NextNavigationPoint)
		{
		if (NP.IsA('BalloonStartA'))
			{
			SpawnPointA = NP.location;
			SpawnFromRoundA = BalloonStart(NP).NumBallonsBeforeSwitch;
			if ( BalloonStartA(NP).bOnlyOneStartPoint )
				bSpawnFromA = True;
			Routes += 1;
			}
		else if (NP.IsA('BalloonStartB'))
			{
			SpawnPointB = NP.location;
			SpawnFromRoundB = BalloonStart(NP).NumBallonsBeforeSwitch;
			Routes += 1;
			}
		else if (NP.IsA('BalloonStartC'))
			{
			SpawnPointC = NP.location;
			SpawnFromRoundC = BalloonStart(NP).NumBallonsBeforeSwitch;
			Routes += 1;
			}
		else if (NP.IsA('BalloonStartD'))
			{
			SpawnPointD = NP.location;
			SpawnFromRoundD = BalloonStart(NP).NumBallonsBeforeSwitch;
			Routes += 1;
			}
		}
	if ( Routes == 0 )
		log("Pop Balloons !ERROR!: Failed to find a 'BalloonStart' actor.");
}

function PreBeginPlay()
{
	Super.PreBeginPlay();
	AddMutator(Level.Spawn(class'PBMutator_Damage'));
	AddMutator(Level.Spawn(class'Stats'));
	LoadMaps();
	CurrentRoute = 1;
	FindSpawnpoint();
	//SaveConfig();
	LookForCustomWaves();
	MapSong = Music(DynamicLoadObject(String(Level.Song), class'Music'));
}

/* Load all PB maps into map array */
function LoadMaps()
{
local string FirstMap,NextMap,MapName,TestMap;
local int i,length,MapCount;

	FirstMap = Level.GetMapName("PB", "", 0);
	NextMap = FirstMap;
	while(!(FirstMap ~= TestMap))
		{
		MapName = NextMap;
		length = InStr(Caps(MapName), ".UNR");
		if(length != -1)
			{
			MapList[MapCount] = MapName;
			MapCount++;
			}
		NextMap = Level.GetMapName("PB", NextMap, 1);
		TestMap = NextMap;
		if(MapCount > 512)
			break;
		}
	for (i=0;MapList[i] != "";i++)
		{
		log("#PB maps#"@i$":"@MapList[i]);
		}
}

function PostBeginPlay()
{
	Super.PostBeginPlay();
	GetCurrentMapName();
	SetTimer(1.0,True);
}

//0.0.0.0/PB-Tunnel.unr?Game=PopBalloons.PopBalloonsGame?Mutator=?Listen?Checksum=NoChecksum?Name=hOmer?Class=B
function GetCurrentMapName()
{
	CurrentMapName = Level.GetLocalURL();
	//IP = Left(IP, InStr(IP, ":"));
	CurrentMapName = Left(CurrentMapName, InStr(CurrentMapName, ".unr"));
	CurrentMapName = Mid(CurrentMapName, InStr(CurrentMapName, "PB-"));
	log("#PB# CurrentMapName:"@CurrentMapName);
}

function Timer()
{
local Pawn P;
local bool bBalloonPresent;
local GRI GRI;
local bool bOpenVoteMenu;

	GRI = GRI(DeathMatchPlus(Level.Game).GameReplicationInfo);
	
	if ( GRI.Lives <= 0 )
		{
		bGameOver = True;
		if ( MapVoteDelay <= 0 )
			{
			bOpenVoteMenu = True;
			}
		else
			MapVoteDelay--;
		}

	if (InitialWait > 0)
		{
		InitialWait--;
		}
	else
		{
		if (!bFirstRun)
			{
			SetupRound(CurrentRound);
			bFirstRun = True;
			}
		else if ( !bGameOver && GRI.bRoundStarted)
			SpawnBalloon();
		}
	if ( bLastBalloonSpawned )
		{
		for ( P=Level.PawnList; P!=None; P=P.nextPawn )
			{
			if ( P.IsA('Balloon'))
				{
				bBalloonPresent = True;
				if ( P.IsA('Balloon_regen') )
					{
					if ( P.Health < P.Default.Health )
						P.Health += 1;
					}
				}
			if ( P.IsA('PlayerPawn') )
				{
				if ( bOpenVoteMenu && !PBPRI(PlayerPawn(P).PlayerReplicationInfo).bDrawVoteMenu)
					{
					P.ConsoleCommand("MUTATE BDBMAPVOTE VOTEMENU");
					}
				}
			}
		if ( !bBalloonPresent )
			{	
			GRI = GRI(DeathMatchPlus(Level.Game).GameReplicationInfo);
			
			if ( GRI.Round == 50 )
				{
				GRI.bVictorious = True;
				UpDateDB(CurrentMapName, True);				//make sure stats actor updates the database
				}
			else if ( !bGameOver )
				{
				CurrentRound += 1;
				GRI.Round += 1;
				SetupRound(CurrentRound);
				bLastBalloonSpawned = False;
				GRI.bRoundStarted = False;
				UpDateDB(CurrentMapName, False);				//make sure stats actor updates the database
				}
			}
		}
}

function SetupRound(int Round)
{
local int NumBalloons;

	Incomming = Rounds[Round];
	SetTimer(RoundSpawnSpeed[Round], True);
	//NumBalloons = Len(Incomming);
	//log("Round:"@Round$" has"@NumBalloons$" balloons.");
}

function SpawnBalloon()
{
local string BalloonType;
local int Length;
//Small:
local Balloon_small_red BSR;
local Balloon_small_blue BSB;
local Balloon_small_green BSG;
local Balloon_small_yellow BSY;
local Balloon_small_purple BSP;
local Balloon_small_white BSW;
local Balloon_small_black BSBl;
//Regen:
local Balloon_regen_red BRR;
local Balloon_regen_blue BRB;
local Balloon_regen_green BRG;
local Balloon_regen_white BRW;
//Metal:
local Balloon_metal_red BMR;
local Balloon_metal_blue BMB;
local Balloon_metal_green BMG;
local Balloon_metal_yellow BMY;
//Clay:
local Balloon_clay_red BCR;
local Balloon_clay_blue BCB;
local Balloon_clay_green BCG;
local Balloon_clay_yellow BCY;
//Liquid:
local Balloon_liquid_light BLL;
local Balloon_liquid_blue BLB;
local Balloon_liquid_green BLG;
local Balloon_liquid_red BLR;
//Zeppelin:
local Balloon_zeppelin_blue ZB;
local Balloon_zeppelin_red ZR;
local Balloon_zeppelin_green ZG;
local Balloon_zeppelin_yellow ZY;
local Balloon_zeppelin_purple ZP;
//BigOnes:
local Balloon_big_red BBR;
local Balloon_big_blue BBB;
local Balloon_big_green BBG;
local Balloon_big_yellow BBY;
//Camo variables:
local int dice;
local bool bCamoBalloon;
local int result;

	//Handle the multiple routes:
	if ( Routes > 1 )
		{
		if ( CurrentRoute == 1 && CurrentlySpawned >= SpawnFromRoundA )
			{
			CurrentlySpawned = 0;
			CurrentRoute = 2;
			}
		else if ( Routes == 2 )
			if ( CurrentRoute == 2 && CurrentlySpawned >= SpawnFromRoundB )
				{
				CurrentlySpawned = 0;
				CurrentRoute = 1;
				}
		else if ( Routes > 2 )
			{
			if ( CurrentRoute == 2 && CurrentlySpawned >= SpawnFromRoundB )
				{
				CurrentlySpawned = 0;
				CurrentRoute = 3;
				}
			else if ( CurrentRoute == 3 && CurrentlySpawned >= SpawnFromRoundC )
				{
				if ( Routes > 3 )
					{
					CurrentlySpawned = 0;
					CurrentRoute = 4;
					}
				else
					{
					CurrentlySpawned = 0;
					CurrentRoute = 1;
					}
				}
			else if ( CurrentRoute == 4 && CurrentlySpawned >= SpawnFromRoundD )
				{
				CurrentlySpawned = 0;
				CurrentRoute = 1;
				}
			}
		}
		
	if ( CurrentRoute == 1 || bSpawnFromA )
		SpawnPoint = SpawnPointA;
	else if ( CurrentRoute == 2 )
		SpawnPoint = SpawnPointB;
	else if ( CurrentRoute == 3 )
		SpawnPoint = SpawnPointC;
	else if ( CurrentRoute == 4 )
		SpawnPoint = SpawnPointD;
	//----------------------------

	CurrentlySpawned++;
	
	GRI = GRI(DeathMatchPlus(Level.Game).GameReplicationInfo);

	if (GRI.Round >= SpawnCamoFromRound)
		{
		//Roll dice to see if balloon should be camouflaged:
		result = 55 - GRI.Round;
		dice = Rand(result);
		if ( dice == 1 )
			bCamoBalloon = True;
		else
			bCamoBalloon = False;
		}

	BalloonType = left(Incomming,1);
	
	if ( bLastBalloonSpawned )
		Return;		
	else if ( BalloonType == "#" )
		{
		bLastBalloonSpawned = True;
		}
		
	Length = len(Incomming);
	Incomming = Right(Incomming, Length - 1);

	if ( BalloonType == "1" )
		{
		BSR = Spawn(Class'Balloon_small_red', , , SpawnPoint);
		BSR.Route = CurrentRoute;
		BSR.DefineBalloonPathNodes();
		BSR.Airspeed = BSR.BaseSpeed * BSR.speed;
		//BSR.DrawScale = BSR.DrawScale * 0.9 * 0.9 * 0.9 * 0.9 * 0.9 * 0.9 * 0.9;
		if ( bCamoBalloon )
			{
			BSR.Style = STY_Translucent;
			BSR.bCamo = True;
			}
		BSR.GotoState('TacticalMove');
		}
	else if ( BalloonType == "2" )
		{
		BSB = Spawn(Class'Balloon_small_blue', , , SpawnPoint);
		BSB.Route = CurrentRoute;
		BSB.DefineBalloonPathNodes();
		BSB.Airspeed = BSB.BaseSpeed * BSB.speed;
		//BSB.DrawScale = BSB.DrawScale * 0.9 * 0.9 * 0.9 * 0.9 * 0.9 * 0.9;
		if ( bCamoBalloon )
			{
			BSB.Style = STY_Translucent;
			BSB.bCamo = True;
			}
		BSB.GotoState('TacticalMove');
		}
	else if ( BalloonType == "3" )
		{
		BSG = Spawn(Class'Balloon_small_green', , , SpawnPoint);
		BSG.Route = CurrentRoute;
		BSG.DefineBalloonPathNodes();
		BSG.Airspeed = BSG.BaseSpeed * BSG.speed;
		//BSG.DrawScale = BSG.DrawScale * 0.9 * 0.9 * 0.9 * 0.9 * 0.9;
		if ( bCamoBalloon )
			{
			BSG.Style = STY_Translucent;
			BSG.bCamo = True;
			}
		BSG.GotoState('TacticalMove');
		}
	else if ( BalloonType == "4" )
		{
		BSY = Spawn(Class'Balloon_small_yellow', , , SpawnPoint);
		BSY.Route = CurrentRoute;
		BSY.DefineBalloonPathNodes();
		BSY.Airspeed = BSY.BaseSpeed * BSY.speed;
		//BSY.DrawScale = BSY.DrawScale * 0.9 * 0.9 * 0.9 * 0.9;
		if ( bCamoBalloon )
			{
			BSY.Style = STY_Translucent;
			BSY.bCamo = True;
			}
		BSY.GotoState('TacticalMove');
		}
	else if ( BalloonType == "5" )
		{
		BSP = Spawn(Class'Balloon_small_purple', , , SpawnPoint);
		BSP.Route = CurrentRoute;
		BSP.DefineBalloonPathNodes();
		BSP.Airspeed = BSP.BaseSpeed * BSP.speed;
		//BSP.DrawScale = BSP.DrawScale * 0.9 * 0.9 * 0.9;
		if ( bCamoBalloon )
			{
			BSP.Style = STY_Translucent;
			BSP.bCamo = True;
			}
		BSP.GotoState('TacticalMove');
		}
	else if ( BalloonType == "6" )
		{
		BSW = Spawn(Class'Balloon_small_white', , , SpawnPoint);
		BSW.Route = CurrentRoute;
		BSW.DefineBalloonPathNodes();
		BSW.Airspeed = BSW.BaseSpeed * BSW.speed;
		//BSW.DrawScale = BSW.DrawScale * 0.9 * 0.9;
		if ( bCamoBalloon )
			{
			BSW.Style = STY_Translucent;
			BSW.bCamo = True;
			}
		BSW.GotoState('TacticalMove');
		}
	else if ( BalloonType == "7" )
		{
		BSBl = Spawn(Class'Balloon_small_black', , , SpawnPoint);
		BSBl.Route = CurrentRoute;
		BSBl.DefineBalloonPathNodes();
		BSBl.Airspeed = BSBl.BaseSpeed * BSBl.speed;
		//BSBl.DrawScale = BSBl.DrawScale * 0.9;
		if ( bCamoBalloon )
			{
			BSBl.Style = STY_Translucent;
			BSBl.bCamo = True;
			}
		BSBl.GotoState('TacticalMove');
		}
	else if ( BalloonType == "8" )
		{
		BRR = Spawn(Class'Balloon_regen_red', , , SpawnPoint);
		BRR.Route = CurrentRoute;
		BRR.DefineBalloonPathNodes();
		BRR.Airspeed = BRR.BaseSpeed * BRR.speed;
		if ( bCamoBalloon )
			{
			BRR.Style = STY_Translucent;
			BRR.bCamo = True;
			}
		BRR.GotoState('TacticalMove');
		}
	else if ( BalloonType == "9" )
		{
		BRB = Spawn(Class'Balloon_regen_blue', , , SpawnPoint);
		BRB.Route = CurrentRoute;
		BRB.DefineBalloonPathNodes();
		BRB.Airspeed = BRB.BaseSpeed * BRB.speed;
		if ( bCamoBalloon )
			{
			BRB.Style = STY_Translucent;
			BRB.bCamo = True;
			}
		BRB.GotoState('TacticalMove');
		}
	else if ( BalloonType == "A" )
		{
		BRG = Spawn(Class'Balloon_regen_green', , , SpawnPoint);
		BRG.Route = CurrentRoute;
		BRG.DefineBalloonPathNodes();
		BRG.Airspeed = BRG.BaseSpeed * BRG.speed;
		if ( bCamoBalloon )
			{
			BRG.Style = STY_Translucent;
			BRG.bCamo = True;
			}
		BRG.GotoState('TacticalMove');
		}
	else if ( BalloonType == "B" )
		{
		BRW = Spawn(Class'Balloon_regen_white', , , SpawnPoint);
		BRW.Route = CurrentRoute;
		BRW.DefineBalloonPathNodes();
		BRW.Airspeed = BRW.BaseSpeed * BRW.speed;
		if ( bCamoBalloon )
			{
			BRW.Style = STY_Translucent;
			BRW.bCamo = True;
			}
		BRW.GotoState('TacticalMove');
		}
	else if ( BalloonType == "C" )
		{
		BBR = Spawn(Class'Balloon_big_red', , , SpawnPoint);
		BBR.Route = CurrentRoute;
		BBR.DefineBalloonPathNodes();
		BBR.Airspeed = BBR.BaseSpeed * BBR.speed;
		if ( bCamoBalloon )
			{
			BBR.Style = STY_Translucent;
			BBR.bCamo = True;
			}
		BBR.GotoState('TacticalMove');
		}
	else if ( BalloonType == "D" )
		{
		BBB = Spawn(Class'Balloon_big_blue', , , SpawnPoint);
		BBB.Route = CurrentRoute;
		BBB.DefineBalloonPathNodes();
		BBB.Airspeed = BBB.BaseSpeed * BBB.speed;
		if ( bCamoBalloon )
			{
			BBB.Style = STY_Translucent;
			BBB.bCamo = True;
			}
		BBB.GotoState('TacticalMove');
		}
	else if ( BalloonType == "E" )
		{
		BBG = Spawn(Class'Balloon_big_green', , , SpawnPoint);
		BBG.Route = CurrentRoute;
		BBG.DefineBalloonPathNodes();
		BBG.Airspeed = BBG.BaseSpeed * BBG.speed;
		if ( bCamoBalloon )
			{
			BBG.Style = STY_Translucent;
			BBG.bCamo = True;
			}
		BBG.GotoState('TacticalMove');
		}
	else if ( BalloonType == "F" )
		{
		BBY = Spawn(Class'Balloon_big_yellow', , , SpawnPoint);
		BBY.Route = CurrentRoute;
		BBY.DefineBalloonPathNodes();
		BBY.Airspeed = BBY.BaseSpeed * BBY.speed;
		if ( bCamoBalloon )
			{
			BBY.Style = STY_Translucent;
			BBY.bCamo = True;
			}
		BBY.GotoState('TacticalMove');
		}
	else if ( BalloonType == "G" )
		{
		BMR = Spawn(Class'Balloon_metal_red', , , SpawnPoint);
		BMR.Route = CurrentRoute;
		BMR.DefineBalloonPathNodes();
		BMR.Airspeed = BMR.BaseSpeed * BMR.speed;
		if ( bCamoBalloon )
			{
			BMR.Style = STY_Translucent;
			BMR.bCamo = True;
			}
		BMR.GotoState('TacticalMove');
		}
	else if ( BalloonType == "H" )
		{
		BMB = Spawn(Class'Balloon_metal_blue', , , SpawnPoint);
		BMB.Route = CurrentRoute;
		BMB.DefineBalloonPathNodes();
		BMB.Airspeed = BMB.BaseSpeed * BMB.speed;
		if ( bCamoBalloon )
			{
			BMB.Style = STY_Translucent;
			BMB.bCamo = True;
			}
		BMB.GotoState('TacticalMove');
		}
	else if ( BalloonType == "I" )
		{
		BMG = Spawn(Class'Balloon_metal_green', , , SpawnPoint);
		BMG.Route = CurrentRoute;
		BMG.DefineBalloonPathNodes();
		BMG.Airspeed = BMG.BaseSpeed * BMG.speed;
		if ( bCamoBalloon )
			{
			BMG.Style = STY_Translucent;
			BMG.bCamo = True;
			}
		BMG.GotoState('TacticalMove');
		}
	else if ( BalloonType == "J" )
		{
		BMY = Spawn(Class'Balloon_metal_yellow', , , SpawnPoint);
		BMY.Route = CurrentRoute;
		BMY.DefineBalloonPathNodes();
		BMY.Airspeed = BMY.BaseSpeed * BMY.speed;
		if ( bCamoBalloon )
			{
			BMY.Style = STY_Translucent;
			BMY.bCamo = True;
			}
		BMY.GotoState('TacticalMove');
		}		
	else if ( BalloonType == "K" )
		{
		BCR = Spawn(Class'Balloon_clay_red', , , SpawnPoint);
		BCR.Route = CurrentRoute;
		BCR.DefineBalloonPathNodes();
		BCR.Airspeed = BCR.BaseSpeed * BCR.speed;
		if ( bCamoBalloon )
			{
			BCR.Style = STY_Translucent;
			BCR.bCamo = True;
			}
		BCR.GotoState('TacticalMove');
		}
	else if ( BalloonType == "L" )
		{
		BCB = Spawn(Class'Balloon_clay_blue', , , SpawnPoint);
		BCB.Route = CurrentRoute;
		BCB.DefineBalloonPathNodes();
		BCB.Airspeed = BCB.BaseSpeed * BCB.speed;
		if ( bCamoBalloon )
			{
			BCB.Style = STY_Translucent;
			BCB.bCamo = True;
			}
		BCB.GotoState('TacticalMove');
		}
	else if ( BalloonType == "M" )
		{
		BCG = Spawn(Class'Balloon_clay_green', , , SpawnPoint);
		BCG.Route = CurrentRoute;
		BCG.DefineBalloonPathNodes();
		BCG.Airspeed = BCG.BaseSpeed * BCG.speed;
		if ( bCamoBalloon )
			{
			BCG.Style = STY_Translucent;
			BCG.bCamo = True;
			}
		BCG.GotoState('TacticalMove');
		}
	else if ( BalloonType == "N" )
		{
		BCY = Spawn(Class'Balloon_clay_yellow', , , SpawnPoint);
		BCY.Route = CurrentRoute;
		BCY.DefineBalloonPathNodes();
		BCY.Airspeed = BCY.BaseSpeed * BCY.speed;
		if ( bCamoBalloon )
			{
			BCY.Style = STY_Translucent;
			BCY.bCamo = True;
			}
		BCY.GotoState('TacticalMove');
		}
	else if ( BalloonType == "O" )
		{
		BLL = Spawn(Class'Balloon_liquid_light', , , SpawnPoint);
		BLL.Route = CurrentRoute;
		BLL.DefineBalloonPathNodes();
		BLL.Airspeed = BLL.BaseSpeed * BLL.speed;
		if ( bCamoBalloon )
			{
			BLL.Style = STY_Translucent;
			BLL.bCamo = True;
			}
		BLL.GotoState('TacticalMove');
		}
	else if ( BalloonType == "P" )
		{
		BLB = Spawn(Class'Balloon_liquid_blue', , , SpawnPoint);
		BLB.Route = CurrentRoute;
		BLB.DefineBalloonPathNodes();
		BLB.Airspeed = BLB.BaseSpeed * BLB.speed;
		if ( bCamoBalloon )
			{
			BLB.Style = STY_Translucent;
			BLB.bCamo = True;
			}
		BLB.GotoState('TacticalMove');
		}
	else if ( BalloonType == "Q" )
		{
		BLG = Spawn(Class'Balloon_liquid_green', , , SpawnPoint);
		BLG.Route = CurrentRoute;
		BLG.DefineBalloonPathNodes();
		BLG.Airspeed = BLG.BaseSpeed * BLG.speed;
		if ( bCamoBalloon )
			{
			BLG.Style = STY_Translucent;
			BLG.bCamo = True;
			}
		BLG.GotoState('TacticalMove');
		}
	else if ( BalloonType == "R" )
		{
		BLR = Spawn(Class'Balloon_liquid_red', , , SpawnPoint);
		BLR.Route = CurrentRoute;
		BLR.DefineBalloonPathNodes();
		BLR.Airspeed = BLR.BaseSpeed * BLR.speed;
		if ( bCamoBalloon )
			{
			BLR.Style = STY_Translucent;
			BLR.bCamo = True;
			}
		BLR.GotoState('TacticalMove');
		}
	else if ( BalloonType == "V" )
		{
		ZR = Spawn(Class'Balloon_zeppelin_red', , , SpawnPoint);
		ZR.Route = CurrentRoute;
		ZR.DefineBalloonPathNodes();
		ZR.Airspeed = ZR.BaseSpeed * ZR.speed;
		if ( bCamoBalloon )
			{
			ZR.Style = STY_Translucent;
			ZR.bCamo = True;
			}
		ZR.GotoState('TacticalMove');
		}
	else if ( BalloonType == "W" )
		{
		ZB = Spawn(Class'Balloon_zeppelin_blue', , , SpawnPoint);
		ZB.Route = CurrentRoute;
		ZB.DefineBalloonPathNodes();
		ZB.Airspeed = ZB.BaseSpeed * ZB.speed;
		if ( bCamoBalloon )
			{
			ZB.Style = STY_Translucent;
			ZB.bCamo = True;
			}
		ZB.GotoState('TacticalMove');
		}
	else if ( BalloonType == "X" )
		{
		ZG = Spawn(Class'Balloon_zeppelin_green', , , SpawnPoint);
		ZG.Route = CurrentRoute;
		ZG.DefineBalloonPathNodes();
		ZG.Airspeed = ZG.BaseSpeed * ZG.speed;
		if ( bCamoBalloon )
			{
			ZG.Style = STY_Translucent;
			ZG.bCamo = True;
			}
		ZG.GotoState('TacticalMove');
		}
	else if ( BalloonType == "Y" )
		{
		ZY = Spawn(Class'Balloon_zeppelin_yellow', , , SpawnPoint);
		ZY.Route = CurrentRoute;
		ZY.DefineBalloonPathNodes();
		ZY.Airspeed = ZY.BaseSpeed * ZY.speed;
		if ( bCamoBalloon )
			{
			ZY.Style = STY_Translucent;
			ZY.bCamo = True;
			}
		ZY.GotoState('TacticalMove');
		}
	else if ( BalloonType == "Z" )
		{
		ZP = Spawn(Class'Balloon_zeppelin_purple', , , SpawnPoint);
		ZP.Route = CurrentRoute;
		ZP.DefineBalloonPathNodes();
		ZP.Airspeed = ZP.BaseSpeed * ZP.speed;
		if ( bCamoBalloon )
			{
			ZP.Style = STY_Translucent;
			ZP.bCamo = True;
			}
		ZP.GotoState('TacticalMove');
		}
}

function ModifyPlayer(Pawn Other)
{
	if ( Other.IsA('PlayerPawn') )
		{
		DeathMatchPlus(Level.Game).GiveWeapon(Other,"PopBalloons.Weapon_Enforcer");
		if ( PBPRI(PlayerPawn(Other).PlayerReplicationInfo).bHasBioRifle )
			DeathMatchPlus(Level.Game).GiveWeapon(Other,"PopBalloons.Weapon_GlueGun");
		if ( PBPRI(PlayerPawn(Other).PlayerReplicationInfo).bHasSniperRifle )
			DeathMatchPlus(Level.Game).GiveWeapon(Other,"PopBalloons.Weapon_SniperRifle");
		if ( PBPRI(PlayerPawn(Other).PlayerReplicationInfo).bHasRazorJack )
			DeathMatchPlus(Level.Game).GiveWeapon(Other,"PopBalloons.Weapon_RazorJack");
		if ( PBPRI(PlayerPawn(Other).PlayerReplicationInfo).bHasMinigun )
			DeathMatchPlus(Level.Game).GiveWeapon(Other,"PopBalloons.Weapon_Minigun");
		if ( PBPRI(PlayerPawn(Other).PlayerReplicationInfo).bHasColdBreeze )
			DeathMatchPlus(Level.Game).GiveWeapon(Other,"PopBalloons.Weapon_ColdBreeze");
		if ( PBPRI(PlayerPawn(Other).PlayerReplicationInfo).bHasRocketLauncher )
			DeathMatchPlus(Level.Game).GiveWeapon(Other,"PopBalloons.Weapon_RocketLauncher");
		if ( PBPRI(PlayerPawn(Other).PlayerReplicationInfo).bHasFlakCannon )
			DeathMatchPlus(Level.Game).GiveWeapon(Other,"PopBalloons.Weapon_FlakCannon");
		if ( PBPRI(PlayerPawn(Other).PlayerReplicationInfo).bHasPulseGun )
			DeathMatchPlus(Level.Game).GiveWeapon(Other,"PopBalloons.Weapon_PulseGun");
		if ( PBPRI(PlayerPawn(Other).PlayerReplicationInfo).bHasShockRifle )
			DeathMatchPlus(Level.Game).GiveWeapon(Other,"PopBalloons.Weapon_ShockRifle");
		if ( PBPRI(PlayerPawn(Other).PlayerReplicationInfo).bHasUzi )
			DeathMatchPlus(Level.Game).GiveWeapon(Other,"PopBalloons.Weapon_Uzi");
			
		Other.PlayerReplicationInfo.Score = StartMoney;
		
		}
	
	if ( NextMutator != None )
		NextMutator.ModifyPlayer(Other);
}

function bool CheckReplacement(Actor Other, out byte bSuperRelevant)
{
	if (Other.IsA('TournamentWeapon'))
		{
		return false;
		}
	return true;
}

function bool AlwaysKeep(Actor Other) 
{
	
	if (Other.IsA('PlayerPawn'))
        {
		PlayerPawn(Other).PlayerReplicationInfoClass = class'PBPRI';
		return true;
		}
	if (Other.IsA('Tower'))
        {
		Tower(Other).PlayerReplicationInfoClass = class'TowerPRI';
		return true;
		}
		
	if (NextMutator != None)
		return (NextMutator.AlwaysKeep(Other));
	
	return false;
}

function bool PreventDeath (Pawn Killed, Pawn Killer, name damageType, vector HitLocation)
{
local Inventory Inv;

if ( Killed.IsA('PlayerPawn') )
	{
	if ( Killed.Inventory != none )
		{
		for (inv=Killed.Inventory; inv!=None; inv=inv.Inventory)
			{
			Killed.Inventory.Destroy();
			}
		}
	}

	if ( NextMutator != None )
		{
		NextMutator.PreventDeath(Killer, Killed, damageType, HitLocation);
		}
	
}

function Mutate (string MutateString, PlayerPawn Sender)
{
local Inventory Inv;
local bool bPlayerHasTowerInv, bTowerFound;
local Music Song;
local string ServerTravelString;
local int TimeToVote, MyInt;
local GRI GRI;
local String MyString;
local Tower T;

	GRI = GRI(DeathMatchPlus(Level.Game).GameReplicationInfo);

	//Check if player wants to sell a tower:
	if ( Left(Caps(MutateString),4) == "SELL" )
		{
		//Do stuff here to check which tower
		MyString = Mid(MutateString, InStr(Caps(MutateString), "SELL"));
		MyInt = Len(MyString);
		MyString = Right(MyString, MyInt - 4);
		MyInt = int(MyString);
		if ( MyInt == 0 )
			BroadcastMessage("You have specified an incorrect tower to be sold, please try again!", True );
		else
			{
			foreach Level.AllActors(Class'Tower',T)
				{
				if ( T.TowerNum == MyInt )
					{
					bTowerFound = True;
					BroadcastMessage("You have successfully sold your"@T.TowerName$" for the price of: $"$T.TowerSellValue, False );
					PBPRI(Sender.PlayerReplicationInfo).Score += T.TowerSellValue;
					T.Base.Destroy();
					T.Destroy();
					Sender.ClientPlaySound(Sound'SellSound', , true);
					}
				}
			if ( !bTowerFound )
				BroadcastMessage("You have specified an incorrect tower to be sold, please try again!", True );
			}
		}
	
	//Check if player wants to open/close the F8 menu:
	if ( Left(Caps(MutateString),15) == "POPBALLOONSMENU" )
		{
		if ( PBPRI(Sender.PlayerReplicationInfo).bMenuOpen )
			{
			PBPRI(Sender.PlayerReplicationInfo).bMenuOpen = False;
			Sender.ClientPlaySound(Sound'UMenu.WindowClose', , true);
			}
		else
			{
			PBPRI(Sender.PlayerReplicationInfo).bMenuOpen = True;
			Sender.ClientPlaySound(Sound'UMenu.WindowOpen', , true);
			}
		}
	
	//MUTATE BDBMAPVOTE VOTEMENU ripped directly from BDBMapVote304 and modified to work better with PB HUD GUI interface ;0)
   if(left(Caps(MutateString),10) == "BDBMAPVOTE")
		{
		if(Mid(Caps(MutateString),11,8) == "VOTEMENU")
			{
			if(!Sender.IsA('Spectator'))
				{
				if ( PBPRI(Sender.PlayerReplicationInfo).bDrawVoteMenu )
					PBPRI(Sender.PlayerReplicationInfo).bDrawVoteMenu = False;
				else
					PBPRI(Sender.PlayerReplicationInfo).bDrawVoteMenu = True;
				}
			else
				Sender.ClientMessage("Spectators are not allowed to vote.");
			}
		}
	
	//Check if player wants to buy item from F8 menu (Enter key):
	if ( Left(Caps(MutateString),12) == "SELECTPLAYER" )
		{
		//Check if player wants to start next round:
		if ( !PBPRI(Sender.PlayerReplicationInfo).bDrawVoteMenu && !PBPRI(Sender.PlayerReplicationInfo).bMenuOpen && !GRI.bRoundStarted )
			{
			GRI.bRoundStarted = True;
			Sender.ReceiveLocalizedMessage( class'NewRoundMessage', GRI.Round, );
			}
		//Check if player voted for a map:
		else if ( PBPRI(Sender.PlayerReplicationInfo).bDrawVoteMenu )
			{
			if ( MapList[PBPRI(Sender.PlayerReplicationInfo).MapNum] != "" )
				{
				BroadcastMessage("Saving stats and changing map to"@MapList[PBPRI(Sender.PlayerReplicationInfo).MapNum], True );
				UpDateDB(CurrentMapName, False);				//make sure stats actor updates the database
				ServerTravelString = MapList[PBPRI(Sender.PlayerReplicationInfo).MapNum]$"?game=PopBalloons.PopBalloonsGame";
				Level.ServerTravel(ServerTravelString, false);
				PBPRI(Sender.PlayerReplicationInfo).bDrawVoteMenu = False;
				}
			}
		//first check if menu is open or not:
		else if ( PBPRI(Sender.PlayerReplicationInfo).bMenuOpen )
			{
			//Now check if player wants to buy a Weapon, Tower or upgrade:
			if ( PBPRI(Sender.PlayerReplicationInfo).bDrawWeaponsMenu )
				{
				//Player wants to buy a weapon, now check which:
				if ( PBPRI(Sender.PlayerReplicationInfo).SelectedWeapon != 0 )
					{
					/* 	0 = Enforcer, 1 = Bio Rifle($1500), 2 = Shock Rifle($2500), 3 = Pulse Gun($2500)
						4 = Razor Jack($2500), 5 = Flak Cannon($4000), 6 = Rocket Launcher($4500)
						7 = Sniper Rifle($5000), 8 = Minigun($8000) */
					if ( PBPRI(Sender.PlayerReplicationInfo).SelectedWeapon == 1 )
						{
						if ( !PBPRI(Sender.PlayerReplicationInfo).bHasBioRifle && PBPRI(Sender.PlayerReplicationInfo).Score >= 1500 && PBPRI(Sender.PlayerReplicationInfo).Rank >= 5 )
							{
							PBPRI(Sender.PlayerReplicationInfo).bHasBioRifle = True;
							DeathMatchPlus(Level.Game).GiveWeapon(Sender,"PopBalloons.Weapon_GlueGun");
							PBPRI(Sender.PlayerReplicationInfo).Score -= 1500;
							Sender.ClientPlaySound(Sound'UMenu.BigSelect', , true);
							}
						}
					else if ( PBPRI(Sender.PlayerReplicationInfo).SelectedWeapon == 2 )
						{
						if ( !PBPRI(Sender.PlayerReplicationInfo).bHasShockRifle && PBPRI(Sender.PlayerReplicationInfo).Score >= 2500 && PBPRI(Sender.PlayerReplicationInfo).Rank >= 8 )
							{
							PBPRI(Sender.PlayerReplicationInfo).bHasShockRifle = True;
							DeathMatchPlus(Level.Game).GiveWeapon(Sender,"PopBalloons.Weapon_ShockRifle");
							PBPRI(Sender.PlayerReplicationInfo).Score -= 2500;
							Sender.ClientPlaySound(Sound'UMenu.BigSelect', , true);
							}
						}
					else if ( PBPRI(Sender.PlayerReplicationInfo).SelectedWeapon == 3 )
						{
						if ( !PBPRI(Sender.PlayerReplicationInfo).bHasPulseGun && PBPRI(Sender.PlayerReplicationInfo).Score >= 2500 && PBPRI(Sender.PlayerReplicationInfo).Rank >= 8 )
							{
							PBPRI(Sender.PlayerReplicationInfo).bHasPulseGun = True;
							DeathMatchPlus(Level.Game).GiveWeapon(Sender,"PopBalloons.Weapon_PulseGun");
							PBPRI(Sender.PlayerReplicationInfo).Score -= 2500;
							Sender.ClientPlaySound(Sound'UMenu.BigSelect', , true);
							}
						}
					else if ( PBPRI(Sender.PlayerReplicationInfo).SelectedWeapon == 4 )
						{
						if ( !PBPRI(Sender.PlayerReplicationInfo).bHasRazorJack && PBPRI(Sender.PlayerReplicationInfo).Score >= 2500 && PBPRI(Sender.PlayerReplicationInfo).Rank >= 10 )
							{
							PBPRI(Sender.PlayerReplicationInfo).bHasRazorJack = True;
							DeathMatchPlus(Level.Game).GiveWeapon(Sender,"PopBalloons.Weapon_RazorJack");
							PBPRI(Sender.PlayerReplicationInfo).Score -= 2500;
							Sender.ClientPlaySound(Sound'UMenu.BigSelect', , true);
							}
						}
					else if ( PBPRI(Sender.PlayerReplicationInfo).SelectedWeapon == 5 )
						{
						if ( !PBPRI(Sender.PlayerReplicationInfo).bHasFlakCannon && PBPRI(Sender.PlayerReplicationInfo).Score >= 5000 && PBPRI(Sender.PlayerReplicationInfo).Rank >= 12 )
							{
							PBPRI(Sender.PlayerReplicationInfo).bHasFlakCannon = True;
							DeathMatchPlus(Level.Game).GiveWeapon(Sender,"PopBalloons.Weapon_FlakCannon");
							PBPRI(Sender.PlayerReplicationInfo).Score -= 5000;
							Sender.ClientPlaySound(Sound'UMenu.BigSelect', , true);
							}
						}
					else if ( PBPRI(Sender.PlayerReplicationInfo).SelectedWeapon == 6 )
						{
						if ( !PBPRI(Sender.PlayerReplicationInfo).bHasRocketLauncher && PBPRI(Sender.PlayerReplicationInfo).Score >= 4500 && PBPRI(Sender.PlayerReplicationInfo).Rank >= 12 )
							{
							PBPRI(Sender.PlayerReplicationInfo).bHasRocketLauncher = True;
							DeathMatchPlus(Level.Game).GiveWeapon(Sender,"PopBalloons.Weapon_RocketLauncher");
							PBPRI(Sender.PlayerReplicationInfo).Score -= 4500;
							Sender.ClientPlaySound(Sound'UMenu.BigSelect', , true);
							}
						}
					else if ( PBPRI(Sender.PlayerReplicationInfo).SelectedWeapon == 7 )
						{
						if ( !PBPRI(Sender.PlayerReplicationInfo).bHasSniperRifle && PBPRI(Sender.PlayerReplicationInfo).Score >= 5000 && PBPRI(Sender.PlayerReplicationInfo).Rank >= 15 )
							{
							PBPRI(Sender.PlayerReplicationInfo).bHasSniperRifle = True;
							DeathMatchPlus(Level.Game).GiveWeapon(Sender,"PopBalloons.Weapon_SniperRifle");
							PBPRI(Sender.PlayerReplicationInfo).Score -= 5000;
							Sender.ClientPlaySound(Sound'UMenu.BigSelect', , true);
							}
						}
					else if ( PBPRI(Sender.PlayerReplicationInfo).SelectedWeapon == 8 )
						{
						if ( !PBPRI(Sender.PlayerReplicationInfo).bHasMinigun && PBPRI(Sender.PlayerReplicationInfo).Score >= 8000  && PBPRI(Sender.PlayerReplicationInfo).Rank >= 20 )
							{
							PBPRI(Sender.PlayerReplicationInfo).bHasMinigun = True;
							DeathMatchPlus(Level.Game).GiveWeapon(Sender,"PopBalloons.Weapon_Minigun");
							PBPRI(Sender.PlayerReplicationInfo).Score -= 8000;
							Sender.ClientPlaySound(Sound'UMenu.BigSelect', , true);
							}
						}
					else if ( PBPRI(Sender.PlayerReplicationInfo).SelectedWeapon == 9 )
						{
						if ( !PBPRI(Sender.PlayerReplicationInfo).bHasUZI && PBPRI(Sender.PlayerReplicationInfo).Score >= 10000  && PBPRI(Sender.PlayerReplicationInfo).Rank >= 20 )
							{
							PBPRI(Sender.PlayerReplicationInfo).bHasUZI = True;
							DeathMatchPlus(Level.Game).GiveWeapon(Sender,"PopBalloons.Weapon_Uzi");
							PBPRI(Sender.PlayerReplicationInfo).Score -= 10000;
							Sender.ClientPlaySound(Sound'UMenu.BigSelect', , true);
							}
						}
					else if ( PBPRI(Sender.PlayerReplicationInfo).SelectedWeapon == 10 )
						{
						if ( !PBPRI(Sender.PlayerReplicationInfo).bHasColdBreeze && PBPRI(Sender.PlayerReplicationInfo).Score >= 6000  && PBPRI(Sender.PlayerReplicationInfo).Rank >= 15 )
							{
							PBPRI(Sender.PlayerReplicationInfo).bHasColdBreeze = True;
							DeathMatchPlus(Level.Game).GiveWeapon(Sender,"PopBalloons.Weapon_ColdBreeze");
							PBPRI(Sender.PlayerReplicationInfo).Score -= 6000;
							Sender.ClientPlaySound(Sound'UMenu.BigSelect', , true);
							}
						}
					}
				}
			else if ( PBPRI(Sender.PlayerReplicationInfo).bDrawTowerMenu )
				{
				for( Inv=Sender.Inventory; Inv!=None; Inv=Inv.Inventory )
					{ 
					if (Inv.IsA('Weapon_Tower')) 
						{
						bPlayerHasTowerInv = True;
						}
					}
				if ( bPlayerHasTowerInv )
					{
					//Player already has a tower, so do nothing.
					}
				else if ( PBPRI(Sender.PlayerReplicationInfo).SelectedTower == 0 )
					{
					if ( PBPRI(Sender.PlayerReplicationInfo).Score >= 1000 )
						{
						DeathMatchPlus(Level.Game).GiveWeapon(Sender,"PopBalloons.Weapon_Tower");
						PBPRI(Sender.PlayerReplicationInfo).Score -= 1000;
						Sender.ClientPlaySound(Sound'UMenu.BigSelect', , true);
						for( Inv=Sender.Inventory; Inv!=None; Inv=Inv.Inventory )
							{ 
							if (Inv.IsA('Weapon_Tower')) 
								{
								Weapon_Tower(Inv).TowerType=Class'Tower_Krall';
								TowerNum++;
								Weapon_Tower(Inv).TowerNum = TowerNum;
								PBPRI(Sender.PlayerReplicationInfo).bHasKrallTower = True;
								}
							}
						}
					PBPRI(Sender.PlayerReplicationInfo).bMenuOpen = False;
					}
				else if ( PBPRI(Sender.PlayerReplicationInfo).SelectedTower == 1 )
					{
					if ( PBPRI(Sender.PlayerReplicationInfo).Score >= 1200 )
						{
						DeathMatchPlus(Level.Game).GiveWeapon(Sender,"PopBalloons.Weapon_Tower");
						PBPRI(Sender.PlayerReplicationInfo).Score -= 1200;
						Sender.ClientPlaySound(Sound'UMenu.BigSelect', , true);
						for( Inv=Sender.Inventory; Inv!=None; Inv=Inv.Inventory )
							{ 
							if (Inv.IsA('Weapon_Tower')) 
								{
								Weapon_Tower(Inv).TowerType=Class'Tower_Slith';
								TowerNum++;
								Weapon_Tower(Inv).TowerNum = TowerNum;
								PBPRI(Sender.PlayerReplicationInfo).bHasSlithTower = True;
								}
							}
						}
					PBPRI(Sender.PlayerReplicationInfo).bMenuOpen = False;
					}
				else if ( PBPRI(Sender.PlayerReplicationInfo).SelectedTower == 2 )
					{
					if ( PBPRI(Sender.PlayerReplicationInfo).Score >= 1000 )
						{
						DeathMatchPlus(Level.Game).GiveWeapon(Sender,"PopBalloons.Weapon_Tower");
						PBPRI(Sender.PlayerReplicationInfo).Score -= 1000;
						Sender.ClientPlaySound(Sound'UMenu.BigSelect', , true);
						for( Inv=Sender.Inventory; Inv!=None; Inv=Inv.Inventory )
							{ 
							if (Inv.IsA('Weapon_Tower')) 
								{
								Weapon_Tower(Inv).TowerType = Class'Tower_LaserCannon';
								TowerNum++;
								Weapon_Tower(Inv).TowerNum = TowerNum;
								PBPRI(Sender.PlayerReplicationInfo).bHasLaserCannon = True;
								}
							}
						}
					PBPRI(Sender.PlayerReplicationInfo).bMenuOpen = False;
					}
				else if ( PBPRI(Sender.PlayerReplicationInfo).SelectedTower == 3 )
					{
					if ( PBPRI(Sender.PlayerReplicationInfo).Score >= 5000 )
						{
						DeathMatchPlus(Level.Game).GiveWeapon(Sender,"PopBalloons.Weapon_Tower");
						PBPRI(Sender.PlayerReplicationInfo).Score -= 5000;
						Sender.ClientPlaySound(Sound'UMenu.BigSelect', , true);
						for( Inv=Sender.Inventory; Inv!=None; Inv=Inv.Inventory )
							{ 
							if (Inv.IsA('Weapon_Tower')) 
								{
								Weapon_Tower(Inv).TowerType=Class'Tower_Warlord';
								TowerNum++;
								Weapon_Tower(Inv).TowerNum = TowerNum;
								PBPRI(Sender.PlayerReplicationInfo).bHasWarlord = True;
								}
							}
						}
					PBPRI(Sender.PlayerReplicationInfo).bMenuOpen = False;
					}
				else if ( PBPRI(Sender.PlayerReplicationInfo).SelectedTower == 4 )
					{
					if ( PBPRI(Sender.PlayerReplicationInfo).Score >= 2000 )
						{
						DeathMatchPlus(Level.Game).GiveWeapon(Sender,"PopBalloons.Weapon_Tower");
						PBPRI(Sender.PlayerReplicationInfo).Score -= 2000;
						Sender.ClientPlaySound(Sound'UMenu.BigSelect', , true);
						for( Inv=Sender.Inventory; Inv!=None; Inv=Inv.Inventory )
							{ 
							if (Inv.IsA('Weapon_Tower')) 
								{
								Weapon_Tower(Inv).TowerType=Class'Tower_Nali';
								TowerNum++;
								Weapon_Tower(Inv).TowerNum = TowerNum;
								PBPRI(Sender.PlayerReplicationInfo).bHasNali = True;
								}
							}
						}
					PBPRI(Sender.PlayerReplicationInfo).bMenuOpen = False;
					}
				else if ( PBPRI(Sender.PlayerReplicationInfo).SelectedTower == 5 )
					{
					if ( PBPRI(Sender.PlayerReplicationInfo).Score >= 4000 )
						{
						DeathMatchPlus(Level.Game).GiveWeapon(Sender,"PopBalloons.Weapon_Tower");
						PBPRI(Sender.PlayerReplicationInfo).Score -= 4000;
						Sender.ClientPlaySound(Sound'UMenu.BigSelect', , true);
						for( Inv=Sender.Inventory; Inv!=None; Inv=Inv.Inventory )
							{ 
							if (Inv.IsA('Weapon_Tower')) 
								{
								Weapon_Tower(Inv).TowerType=Class'Tower_RingOfFire';
								TowerNum++;
								Weapon_Tower(Inv).TowerNum = TowerNum;
								PBPRI(Sender.PlayerReplicationInfo).bHasRingOfFire = True;
								}
							}
						}
					PBPRI(Sender.PlayerReplicationInfo).bMenuOpen = False;
					}
				}
			else if ( PBPRI(Sender.PlayerReplicationInfo).bDrawUpgradeMenu )
				{
				//Player wants to buy an upgrade, now check which:
				//Tower_Krall
				if ( PBPRI(Sender.PlayerReplicationInfo).SelectedUpgrade == 0 )
					{
					if ( PBPRI(Sender.PlayerReplicationInfo).bHasKrallTower )
						{
						if ( PBPRI(Sender.PlayerReplicationInfo).KrallLevel == 0 && Sender.PlayerReplicationInfo.Score >= 500 )
							{
							//Player bought level 1 Krall upgrade:
							PBPRI(Sender.PlayerReplicationInfo).KrallLevel = 1;
							Sender.PlayerReplicationInfo.Score -= 500;
							PBPRI(Sender.PlayerReplicationInfo).bMenuOpen = False;
							Sender.ClientPlaySound(Sound'UMenu.BigSelect', , true);
							}
						else if ( PBPRI(Sender.PlayerReplicationInfo).KrallLevel == 1 && Sender.PlayerReplicationInfo.Score >= 750 )
							{
							//Player bought level 2 Krall upgrade:
							PBPRI(Sender.PlayerReplicationInfo).KrallLevel = 2;
							Sender.PlayerReplicationInfo.Score -= 750;
							PBPRI(Sender.PlayerReplicationInfo).bMenuOpen = False;
							Sender.ClientPlaySound(Sound'UMenu.BigSelect', , true);
							}
						else if ( PBPRI(Sender.PlayerReplicationInfo).KrallLevel == 2 && Sender.PlayerReplicationInfo.Score >= 1000 )
							{
							//Player bought level 3 Krall upgrade:
							PBPRI(Sender.PlayerReplicationInfo).KrallLevel = 3;
							Sender.PlayerReplicationInfo.Score -= 1000;
							PBPRI(Sender.PlayerReplicationInfo).bMenuOpen = False;
							Sender.ClientPlaySound(Sound'UMenu.BigSelect', , true);
							}
						}
					}
				//Tower_Slith
				if ( PBPRI(Sender.PlayerReplicationInfo).SelectedUpgrade == 1 )
					{
					if ( PBPRI(Sender.PlayerReplicationInfo).bHasSlithTower )
						{
						if ( PBPRI(Sender.PlayerReplicationInfo).SlithLevel == 0 && Sender.PlayerReplicationInfo.Score >= 500 )
							{
							//Player bought level 1 Slith upgrade:
							PBPRI(Sender.PlayerReplicationInfo).SlithLevel = 1;
							Sender.PlayerReplicationInfo.Score -= 500;
							PBPRI(Sender.PlayerReplicationInfo).bMenuOpen = False;
							Sender.ClientPlaySound(Sound'UMenu.BigSelect', , true);
							}
						else if ( PBPRI(Sender.PlayerReplicationInfo).SlithLevel == 1 && Sender.PlayerReplicationInfo.Score >= 750 )
							{
							//Player bought level 2 Slith upgrade:
							PBPRI(Sender.PlayerReplicationInfo).SlithLevel = 2;
							Sender.PlayerReplicationInfo.Score -= 750;
							PBPRI(Sender.PlayerReplicationInfo).bMenuOpen = False;
							Sender.ClientPlaySound(Sound'UMenu.BigSelect', , true);
							}
						else if ( PBPRI(Sender.PlayerReplicationInfo).SlithLevel == 2 && Sender.PlayerReplicationInfo.Score >= 1000 )
							{
							//Player bought level 3 Slith upgrade:
							PBPRI(Sender.PlayerReplicationInfo).SlithLevel = 3;
							Sender.PlayerReplicationInfo.Score -= 1000;
							PBPRI(Sender.PlayerReplicationInfo).bMenuOpen = False;
							Sender.ClientPlaySound(Sound'UMenu.BigSelect', , true);
							}
						}
					}
				//Tower_LaserCannon
				if ( PBPRI(Sender.PlayerReplicationInfo).SelectedUpgrade == 2 )
					{
					if ( PBPRI(Sender.PlayerReplicationInfo).bHasLaserCannon )
						{
						if ( PBPRI(Sender.PlayerReplicationInfo).LaserCannonLevel == 0 && Sender.PlayerReplicationInfo.Score >= 400 )
							{
							//Player bought level 1 Laser Cannon upgrade:
							PBPRI(Sender.PlayerReplicationInfo).LaserCannonLevel = 1;
							Sender.PlayerReplicationInfo.Score -= 400;
							PBPRI(Sender.PlayerReplicationInfo).bMenuOpen = False;
							Sender.ClientPlaySound(Sound'UMenu.BigSelect', , true);
							}
						else if ( PBPRI(Sender.PlayerReplicationInfo).LaserCannonLevel == 1 && Sender.PlayerReplicationInfo.Score >= 500 )
							{
							//Player bought level 2 Laser Cannon upgrade:
							PBPRI(Sender.PlayerReplicationInfo).LaserCannonLevel = 2;
							Sender.PlayerReplicationInfo.Score -= 500;
							PBPRI(Sender.PlayerReplicationInfo).bMenuOpen = False;
							Sender.ClientPlaySound(Sound'UMenu.BigSelect', , true);
							}
						else if ( PBPRI(Sender.PlayerReplicationInfo).LaserCannonLevel == 2 && Sender.PlayerReplicationInfo.Score >= 600 )
							{
							//Player bought level 3 Laser Cannon upgrade:
							PBPRI(Sender.PlayerReplicationInfo).LaserCannonLevel = 3;
							Sender.PlayerReplicationInfo.Score -= 600;
							PBPRI(Sender.PlayerReplicationInfo).bMenuOpen = False;
							Sender.ClientPlaySound(Sound'UMenu.BigSelect', , true);
							}
						}
					}
				//Tower_Warlord
				if ( PBPRI(Sender.PlayerReplicationInfo).SelectedUpgrade == 3 )
					{
					if ( PBPRI(Sender.PlayerReplicationInfo).bHasWarlord )
						{
						if ( PBPRI(Sender.PlayerReplicationInfo).WarlordLevel == 0 && Sender.PlayerReplicationInfo.Score >= 1000 )
							{
							//Player bought level 1 Warlord upgrade:
							PBPRI(Sender.PlayerReplicationInfo).WarlordLevel = 1;
							Sender.PlayerReplicationInfo.Score -= 1000;
							PBPRI(Sender.PlayerReplicationInfo).bMenuOpen = False;
							Sender.ClientPlaySound(Sound'UMenu.BigSelect', , true);
							}
						else if ( PBPRI(Sender.PlayerReplicationInfo).WarlordLevel == 1 && Sender.PlayerReplicationInfo.Score >= 1500 )
							{
							//Player bought level 2 Warlord upgrade:
							PBPRI(Sender.PlayerReplicationInfo).WarlordLevel = 2;
							Sender.PlayerReplicationInfo.Score -= 1500;
							PBPRI(Sender.PlayerReplicationInfo).bMenuOpen = False;
							Sender.ClientPlaySound(Sound'UMenu.BigSelect', , true);
							}
						else if ( PBPRI(Sender.PlayerReplicationInfo).WarlordLevel == 2 && Sender.PlayerReplicationInfo.Score >= 2000 )
							{
							//Player bought level 3 Warlord upgrade:
							PBPRI(Sender.PlayerReplicationInfo).WarlordLevel = 3;
							Sender.PlayerReplicationInfo.Score -= 2000;
							PBPRI(Sender.PlayerReplicationInfo).bMenuOpen = False;
							Sender.ClientPlaySound(Sound'UMenu.BigSelect', , true);
							}
						}
					}
				//Tower_Nali
				if ( PBPRI(Sender.PlayerReplicationInfo).SelectedUpgrade == 4 )
					{
					if ( PBPRI(Sender.PlayerReplicationInfo).bHasNali )
						{
						if ( PBPRI(Sender.PlayerReplicationInfo).NaliLevel == 0 && Sender.PlayerReplicationInfo.Score >= 750 )
							{
							//Player bought level 1 Nali upgrade:
							PBPRI(Sender.PlayerReplicationInfo).NaliLevel = 1;
							Sender.PlayerReplicationInfo.Score -= 750;
							PBPRI(Sender.PlayerReplicationInfo).bMenuOpen = False;
							Sender.ClientPlaySound(Sound'UMenu.BigSelect', , true);
							}
						else if ( PBPRI(Sender.PlayerReplicationInfo).NaliLevel == 1 && Sender.PlayerReplicationInfo.Score >= 750 )
							{
							//Player bought level 2 Nali upgrade:
							PBPRI(Sender.PlayerReplicationInfo).NaliLevel = 2;
							Sender.PlayerReplicationInfo.Score -= 750;
							PBPRI(Sender.PlayerReplicationInfo).bMenuOpen = False;
							Sender.ClientPlaySound(Sound'UMenu.BigSelect', , true);
							}
						else if ( PBPRI(Sender.PlayerReplicationInfo).NaliLevel == 2 && Sender.PlayerReplicationInfo.Score >= 1250 )
							{
							//Player bought level 3 Nali upgrade:
							PBPRI(Sender.PlayerReplicationInfo).NaliLevel = 3;
							Sender.PlayerReplicationInfo.Score -= 1250;
							PBPRI(Sender.PlayerReplicationInfo).bMenuOpen = False;
							Sender.ClientPlaySound(Sound'UMenu.BigSelect', , true);
							}
						}
					}
				//Tower_RingOfFire
				if ( PBPRI(Sender.PlayerReplicationInfo).SelectedUpgrade == 5 )
					{
					if ( PBPRI(Sender.PlayerReplicationInfo).bHasRingOfFire )
						{
						if ( PBPRI(Sender.PlayerReplicationInfo).RingOfFireLevel == 0 && Sender.PlayerReplicationInfo.Score >= 750 )
							{
							//Player bought level 1 Ring Of Fire upgrade:
							PBPRI(Sender.PlayerReplicationInfo).RingOfFireLevel = 1;
							Sender.PlayerReplicationInfo.Score -= 1250;
							PBPRI(Sender.PlayerReplicationInfo).bMenuOpen = False;
							Sender.ClientPlaySound(Sound'UMenu.BigSelect', , true);
							}
						else if ( PBPRI(Sender.PlayerReplicationInfo).RingOfFireLevel == 1 && Sender.PlayerReplicationInfo.Score >= 750 )
							{
							//Player bought level 2 Ring Of Fire upgrade:
							PBPRI(Sender.PlayerReplicationInfo).RingOfFireLevel = 2;
							Sender.PlayerReplicationInfo.Score -= 1500;
							PBPRI(Sender.PlayerReplicationInfo).bMenuOpen = False;
							Sender.ClientPlaySound(Sound'UMenu.BigSelect', , true);
							}
						else if ( PBPRI(Sender.PlayerReplicationInfo).RingOfFireLevel == 2 && Sender.PlayerReplicationInfo.Score >= 1250 )
							{
							//Player bought level 3 Ring Of Fire upgrade:
							PBPRI(Sender.PlayerReplicationInfo).RingOfFireLevel = 3;
							Sender.PlayerReplicationInfo.Score -= 2000;
							PBPRI(Sender.PlayerReplicationInfo).bMenuOpen = False;
							Sender.ClientPlaySound(Sound'UMenu.BigSelect', , true);
							}
						}
					}
				//Camo Detection upgrade:
				if ( PBPRI(Sender.PlayerReplicationInfo).SelectedUpgrade == 6 )
					{
					if ( !PBPRI(Sender.PlayerReplicationInfo).bHasCamoDetection  && Sender.PlayerReplicationInfo.Score >= 1000 )
						{
						//Player bought Camo Detection upgrade:
						PBPRI(Sender.PlayerReplicationInfo).bHasCamoDetection = True;
						Sender.PlayerReplicationInfo.Score -= 1000;
						PBPRI(Sender.PlayerReplicationInfo).bMenuOpen = False;
						Sender.ClientPlaySound(Sound'UMenu.BigSelect', , true);
						}
					}
				}
			else if ( PBPRI(Sender.PlayerReplicationInfo).bDrawMusicMenu )
				{
				PBPRI(Sender.PlayerReplicationInfo).PlayingSong = PBPRI(Sender.PlayerReplicationInfo).SelectedSong;
				If ( PBPRI(Sender.PlayerReplicationInfo).SelectedSong == 30 )
					{
					Sender.ClientSetMusic( MapSong, Level.SongSection, Level.CdTrack, MTRAN_Fade );
					}
				else
					{
					Song = Songs[PBPRI(Sender.PlayerReplicationInfo).SelectedSong];
					Sender.ClientSetMusic( Song, Sender.SongSection, Sender.CdTrack, MTRAN_Fade );
					}
				}
			}
		}
	
	Super.Mutate(MutateString,Sender);
}

defaultproperties
{
MapVoteDelay=10
InitialWait=10
CurrentRound=0
StartMoney=100
SpawnCamoFromRound=15
Songs(0)=Music'Botmca9.Botmca9'
Songs(1)=Music'Botpck10.Botpck10'
Songs(2)=Music'Cannon.Cannon'
Songs(3)=Music'Colossus.Colossus'
Songs(4)=Music'Course.Course'
Songs(5)=Music'Credits.Trophy'
Songs(6)=Music'Ending.Ending'
Songs(7)=Music'Enigma.Enigma'
Songs(8)=Music'firebr.Firebr'
Songs(9)=Music'Foregone.Foregone'
Songs(10)=Music'Godown.Godown'
Songs(11)=Music'Lock.Lock'
Songs(12)=Music'Mech8.Mech8'
Songs(13)=Music'Mission.Mission'
Songs(14)=Music'Nether.Nether'
Songs(15)=Music'Organic.Organic'
Songs(16)=Music'Phantom.Phantom'
Songs(17)=Music'Razor-ub.Razor-ub'
Songs(18)=Music'Run.Run'
Songs(19)=Music'SaveMe.SaveMe'
Songs(20)=Music'Savemeg.Savemeg'
Songs(21)=Music'Seeker.Seeker'
Songs(22)=Music'Seeker2.Seeker2'
Songs(23)=Music'Skyward.Skyward'
Songs(24)=Music'Strider.Strider'
Songs(25)=Music'Suprfist.Suprfist'
Songs(26)=Music'UnWorld2.unworld2'
Songs(27)=Music'utmenu23.utmenu23'
Songs(28)=Music'Uttitle.Uttitle'
Songs(29)=Music'Wheels.Wheels'
}
